{{-- resources/views/talenta/sandbox/employees/edit.blade.php --}}
@extends('layouts.app')
@section('title','Sandbox – Employees')
@section('page-title','Ubah Karyawan (Sandbox)')

@section('content')
@php
    // Helper prefill singkat
    $p  = $emp['personal']  ?? [];
    $e  = $emp['employment']?? [];

    $val = function($oldKey, $fallback) {
        $ov = old($oldKey);
        return isset($ov) ? $ov : $fallback;
    };

    $uid = data_get($emp, 'user_id');
@endphp

<div class="max-w-6xl mx-auto">
    {{-- Header --}}
    <div class="bg-white rounded-2xl shadow-sm border border-gray-100 px-5 py-4 mb-5 flex items-center justify-between">
        <div>
            <h2 class="text-lg font-semibold text-gray-900">
                Edit Karyawan – Sandbox
            </h2>
            <p class="text-sm text-gray-500">
                Ubah data personal, employment, dan kompensasi. Kolom bertanda
                <span class="text-red-600">*</span> wajib diisi.
            </p>
        </div>
        <a href="{{ route('talenta.sandbox.employees.index') }}"
           class="inline-flex items-center gap-2 text-sm px-3 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
           ← Kembali
        </a>
    </div>

    {{-- Alerts (server-side errors list) --}}
    @if($errors->any())
        <div class="mb-5 rounded-xl border border-red-200 bg-red-50 text-red-700 px-4 py-3">
            <div class="font-semibold mb-1">Form belum lengkap</div>
            <ul class="list-disc ml-5 text-sm">
                @foreach($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- Card: Debug Employee --}}
    <details class="mb-5">
        <summary class="cursor-pointer text-sm text-gray-600 hover:text-gray-800">
            Lihat raw data employee (debug)
        </summary>
        <div class="mt-2 bg-white rounded-xl border border-gray-100 p-3">
            <pre class="text-xs text-gray-600 whitespace-pre-wrap">{{ json_encode($emp ?? [], JSON_PRETTY_PRINT) }}</pre>
        </div>
    </details>

    <form action="{{ route('talenta.sandbox.employees.update', $uid) }}" method="POST" class="space-y-6">
        @csrf
        @method('PUT')

        {{-- ================= PERSONAL ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Personal</h3>
                <p class="text-sm text-gray-500">Data dasar karyawan.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Employee ID (wajib) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">
                        Employee ID <span class="text-red-600">*</span>
                    </label>
                    <input type="text" name="employee_id"
                           value="{{ $val('employee_id', data_get($e,'employee_id')) }}"
                           class="w-full rounded-xl border @error('employee_id') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="EMP0001">
                    @error('employee_id')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- First Name (wajib) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">First Name <span class="text-red-600">*</span></label>
                    <input type="text" name="first_name"
                           value="{{ $val('first_name', data_get($p,'first_name')) }}"
                           class="w-full rounded-xl border @error('first_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('first_name')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Last Name --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Last Name</label>
                    <input type="text" name="last_name"
                           value="{{ $val('last_name', data_get($p,'last_name')) }}"
                           class="w-full rounded-xl border border-gray-300 px-3 py-2">
                </div>

                {{-- Email (wajib) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Email <span class="text-red-600">*</span></label>
                    <input type="email" name="email"
                           value="{{ $val('email', data_get($p,'email')) }}"
                           class="w-full rounded-xl border @error('email') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required placeholder="nama@perusahaan.com">
                    @error('email')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Birthdate (wajib) --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Birthdate <span class="text-red-600">*</span></label>
                    <input type="date" name="date_of_birth"
                           value="{{ $val('date_of_birth', data_get($p,'date_of_birth')) }}"
                           class="w-full rounded-xl border @error('date_of_birth') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                           required>
                    @error('date_of_birth')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Gender (wajib) --}}
                @php $genderPref = $val('gender', data_get($p,'gender_text') ?: (data_get($p,'gender')==1?'Male':(data_get($p,'gender')==2?'Female':''))); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Gender <span class="text-red-600">*</span></label>
                    <select name="gender"
                            class="w-full rounded-xl border @error('gender') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($genders ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $genderPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('gender')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Marital Status (wajib) --}}
                @php $marPref = $val('marital_status', data_get($p,'marital_status_text')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Marital Status <span class="text-red-600">*</span></label>
                    <select name="marital_status"
                            class="w-full rounded-xl border @error('marital_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($maritals ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $marPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('marital_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Religion (wajib) --}}
                @php $relPref = $val('religion', data_get($p,'religion_text')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Religion <span class="text-red-600">*</span></label>
                    <select name="religion"
                            class="w-full rounded-xl border @error('religion') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($religs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $relPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('religion')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>
            </div>
        </section>

        {{-- ================= EMPLOYMENT ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Informasi Employment</h3>
                <p class="text-sm text-gray-500">Pemetaan organisasi & status kerja.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Branch (wajib) --}}
                @php $branchPref = $val('branch', data_get($e,'branch')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Branch <span class="text-red-600">*</span></label>
                    <select name="branch"
                            class="w-full rounded-2xl border @error('branch') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($branches ?? []) as $opt)
                            <option value="{{ $opt['name'] }}"
                                {{ $branchPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }} @if(($opt['id'] ?? '')!=='') (ID: {{ $opt['id'] }}) @endif
                            </option>
                        @endforeach
                    </select>
                    @error('branch')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">Contoh: “Pusat”.</p>
                </div>

                {{-- Organization (wajib) --}}
                @php $orgPref = $val('organization_name', data_get($e,'organization_name')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Organization <span class="text-red-600">*</span></label>
                    <select name="organization_name"
                            class="w-full rounded-2xl border @error('organization_name') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($orgs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $orgPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('organization_name')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Job Position (wajib) --}}
                @php $posPref = $val('job_position', data_get($e,'job_position')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Position <span class="text-red-600">*</span></label>
                    <select name="job_position"
                            class="w-full rounded-2xl border @error('job_position') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($jobs ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $posPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('job_position')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Job Level (wajib; jika master kosong → teks) --}}
                @php $lvlPref = $val('job_level', data_get($e,'job_level')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Job Level <span class="text-red-600">*</span></label>
                    @if(!empty($levels))
                        <select name="job_level"
                                class="w-full rounded-2xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                            <option value="">-- Pilih --</option>
                            @foreach($levels as $opt)
                                <option value="{{ $opt['name'] }}" {{ $lvlPref == $opt['name'] ? 'selected' : '' }}>
                                    {{ $opt['name'] }}
                                </option>
                            @endforeach
                        </select>
                    @else
                        <input type="text" name="job_level" value="{{ $lvlPref }}"
                               class="w-full rounded-2xl border @error('job_level') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2"
                               required placeholder='mis. "Manager" (master job level kosong)'>
                        <p class="text-xs text-gray-500 mt-1">Master Job Level kosong.</p>
                    @endif
                    @error('job_level')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Employment Status (wajib) --}}
                @php $empStatPref = (string)$val('employment_status', (string)data_get($e,'employment_status_id') ?: (string)data_get($e,'employment_status')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employment Status <span class="text-red-600">*</span></label>
                    <select name="employment_status" id="employment_status"
                            class="w-full rounded-2xl border @error('employment_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($emps ?? []) as $opt)
                            <option value="{{ $opt['id'] }}" {{ (string)$empStatPref === (string)$opt['id'] ? 'selected' : '' }}>
                                {{ $opt['name'] }} (ID: {{ $opt['id'] }})
                            </option>
                        @endforeach
                    </select>
                    @error('employment_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                    <p class="text-xs text-gray-500 mt-1">Contract (ID=2) wajib isi End Date.</p>
                </div>

                {{-- End Employment Status Date (opsional, tapi wajib jika status=2) --}}
                @php $endPref = $val('end_employment_status_date', data_get($e,'end_employment_status_date')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">End Employment Status Date</label>
                    <input type="date" name="end_employment_status_date" id="end_employment_status_date"
                           value="{{ $endPref }}"
                           class="w-full rounded-2xl border @error('end_employment_status_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2">
                    @error('end_employment_status_date')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Join Date (wajib) --}}
                @php $joinPref = $val('join_date', data_get($e,'join_date')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Join Date <span class="text-red-600">*</span></label>
                    <input type="date" name="join_date" value="{{ $joinPref }}"
                           class="w-full rounded-2xl border @error('join_date') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                    @error('join_date')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Schedule (wajib) --}}
                @php $schPref = $val('schedule', data_get($e,'schedule')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Schedule <span class="text-red-600">*</span></label>
                    <select name="schedule"
                            class="w-full rounded-2xl border @error('schedule') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($schedules ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ $schPref == $opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('schedule')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>
            </div>
        </section>

        {{-- ================= KOMPENSASI & PAJAK ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Kompensasi & Pajak</h3>
                <p class="text-sm text-gray-500">Field wajib sama seperti create. Lainnya opsional.</p>
            </div>

            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                {{-- Basic Salary (wajib) --}}
                @php $salPref = $val('basic_salary', data_get($e,'basic_salary')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Basic Salary <span class="text-red-600">*</span></label>
                    <input type="number" min="0" step="1" name="basic_salary" value="{{ $salPref }}"
                           class="w-full rounded-2xl border @error('basic_salary') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                    @error('basic_salary')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- PTKP (wajib) --}}
                @php $ptkpPref = $val('ptkp_status', data_get($e,'ptkp_status_text') ?: data_get($e,'ptkp_status')); @endphp
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">PTKP Status <span class="text-red-600">*</span></label>
                    <select name="ptkp_status"
                            class="w-full rounded-2xl border @error('ptkp_status') border-red-300 ring-2 ring-red-100 @else border-gray-300 @enderror px-3 py-2" required>
                        <option value="">-- Pilih --</option>
                        @foreach(($ptkps ?? []) as $opt)
                            <option value="{{ $opt['name'] }}" {{ (string)$ptkpPref === (string)$opt['name'] ? 'selected' : '' }}>
                                {{ $opt['name'] }}
                            </option>
                        @endforeach
                    </select>
                    @error('ptkp_status')<p class="text-xs text-red-600 mt-1">{{ $message }}</p>@enderror
                </div>

                {{-- Opsional lain sesuai contoh Talenta --}}
                @php
                    $taxConfPref  = $val('tax_configuration', data_get($e,'tax_configuration'));
                    $typeSalPref  = $val('type_salary', data_get($e,'type_salary'));
                    $salConfPref  = $val('salary_configuration', data_get($e,'salary_configuration'));
                    $jhtPref      = $val('jht_configuration', data_get($e,'jht_configuration'));
                    $empTaxPref   = $val('employee_tax_status', data_get($e,'employee_tax_status'));
                    $jpConfPref   = $val('jp_configuration', data_get($e,'jp_configuration'));
                    $overtimePref = $val('overtime_status', data_get($e,'overtime_status'));
                    $bpjsKesPref  = $val('bpjs_kesehatan_config', data_get($e,'bpjs_kesehatan_config'));
                @endphp

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Tax Configuration</label>
                    <select name="tax_configuration" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Gross',2=>'Net',3=>'Gross Up'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$taxConfPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Type Salary</label>
                    <select name="type_salary" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Monthly',2=>'Daily'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$typeSalPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Salary Configuration</label>
                    <select name="salary_configuration" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Gross',2=>'Net'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$salConfPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">JHT Configuration</label>
                    <select name="jht_configuration" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([0=>'None',1=>'By Employee',2=>'By Company',3=>'Both'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$jhtPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Employee Tax Status</label>
                    <input type="number" name="employee_tax_status" min="0" max="12"
                           value="{{ $empTaxPref !== null ? $empTaxPref : 0 }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">JP Configuration</label>
                    <select name="jp_configuration" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([0=>'None',1=>'By Employee',2=>'By Company',3=>'Both'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$jpConfPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Overtime</label>
                    <select name="overtime_status" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Yes',2=>'No'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$overtimePref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">BPJS Kesehatan Class</label>
                    <select name="bpjs_kesehatan_config" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @foreach([1=>'Class 1',2=>'Class 2',3=>'Class 3'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (int)$bpjsKesPref === $k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>

                {{-- NPP BPJS TK --}}
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-gray-700 mb-1">NPP BPJS Ketenagakerjaan</label>
                    <input type="text" name="npp_bpjs_ketenagakerjaan"
                           value="{{ $val('npp_bpjs_ketenagakerjaan', data_get($e,'npp_bpjs_ketenagakerjaan') ?: 'default') }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2"
                           placeholder='isi "default" jika tidak tahu'>
                </div>
            </div>
        </section>

        {{-- ================= LAINNYA (OPSIONAL) ================= --}}
        <section class="bg-white rounded-2xl shadow-sm border border-gray-100">
            <div class="px-5 py-4 border-b border-gray-100">
                <h3 class="font-semibold text-gray-900">Field Lain (Opsional)</h3>
                <p class="text-sm text-gray-500">Sesuai contoh payload dokumentasi.</p>
            </div>
            <div class="p-5 grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">BPJS Ketenagakerjaan (No Peserta)</label>
                    <input type="text" name="bpjs_ketenagakerjaan"
                           value="{{ $val('bpjs_ketenagakerjaan', data_get($e,'bpjs_ketenagakerjaan')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Payment Schedule</label>
                    <input type="text" name="payment_schedule"
                           value="{{ $val('payment_schedule', data_get($e,'payment_schedule')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Invite ESS</label>
                    <select name="invite_ess" class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                        @php $invPref = (string)$val('invite_ess', data_get($e,'invite_ess')); @endphp
                        @foreach(['true'=>'true','false'=>'false'] as $k=>$lbl)
                            <option value="{{ $k }}" {{ (string)$invPref===(string)$k ? 'selected' : '' }}>{{ $lbl }}</option>
                        @endforeach
                    </select>
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Prorate Type</label>
                    <input type="number" min="0" name="prorate_type"
                           value="{{ $val('prorate_type', data_get($e,'prorate_type')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="cth: 1">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">JP Date</label>
                    <input type="date" name="jp_date"
                           value="{{ $val('jp_date', data_get($e,'jp_date')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Approval Line</label>
                    <input type="text" name="approval_line"
                           value="{{ $val('approval_line', data_get($e,'approval_line')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="OBIWAN-11">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Home Phone</label>
                    <input type="text" name="home_phone_number"
                           value="{{ $val('home_phone_number', data_get($p,'home_phone_number')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Mobile Phone</label>
                    <input type="text" name="mobile_phone_number"
                           value="{{ $val('mobile_phone_number', data_get($p,'mobile_phone_number')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                    <input type="text" name="class"
                           value="{{ $val('class', data_get($e,'class')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="Atas">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Grade</label>
                    <input type="text" name="grade"
                           value="{{ $val('grade', data_get($e,'grade')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="A">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Postal Code</label>
                    <input type="text" name="postal_code"
                           value="{{ $val('postal_code', data_get($p,'postal_code') ?: data_get($e,'postal_code')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="65868">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Bank Account</label>
                    <input type="text" name="bank_account"
                           value="{{ $val('bank_account', data_get($e,'bank_account')) }}"
                           class="w-full rounded-2xl border border-gray-300 px-3 py-2" placeholder="120938">
                </div>

                {{-- Custom Fields (contoh) --}}
                <div class="md:col-span-2 grid grid-cols-1 md:grid-cols-2 gap-5">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Custom: Lucky_Date</label>
                        <input type="date" name="custom_fields[Lucky_Date]"
                               value="{{ old('custom_fields.Lucky_Date') ?? data_get($emp,'custom_fields.Lucky_Date') }}"
                               class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Custom: Cost_Center</label>
                        <input type="text" name="custom_fields[Cost_Center]"
                               value="{{ old('custom_fields.Cost_Center') ?? data_get($emp,'custom_fields.Cost_Center') }}"
                               class="w-full rounded-2xl border border-gray-300 px-3 py-2">
                    </div>
                </div>
            </div>
        </section>

        {{-- ================= ACTIONS ================= --}}
        <div class="bg-white rounded-2xl shadow-sm border border-gray-100 p-4 md:sticky md:bottom-4">
            <div class="flex flex-col md:flex-row items-stretch md:items-center justify-between gap-3">
                <p class="text-sm text-gray-500">Simpan perubahan yang sudah dilakukan.</p>
                <div class="flex items-center gap-3">
                    <a href="{{ route('talenta.sandbox.employees.show', $uid) }}"
                       class="inline-flex items-center justify-center px-4 py-2 rounded-xl border border-gray-200 hover:bg-gray-50">
                        Batal
                    </a>
                    <button type="submit"
                            class="inline-flex items-center justify-center px-4 py-2 rounded-xl text-white bg-primary hover:opacity-90">
                        Simpan Perubahan
                    </button>
                </div>
            </div>
        </div>
    </form>
</div>

{{-- SweetAlert2 + dynamic rules --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    // Flash success/error
    @if(session('success'))
        Swal.fire({
            icon: 'success',
            title: 'Berhasil',
            text: @json(session('success')),
            confirmButtonText: 'OK',
            timer: 2000,
            timerProgressBar: true
        });
    @endif
    @if($errors->any() || session('error'))
        Swal.fire({
            icon: 'error',
            title: 'Gagal',
            html: `{!! session('error') ? e(session('error')) : 'Periksa pesan kesalahan pada bagian atas form.' !!}`,
            confirmButtonText: 'OK'
        });
    @endif

    // End date wajib jika Employment Status = 2 (Contract)
    const selStatus = document.getElementById('employment_status');
    const endDate   = document.getElementById('end_employment_status_date');
    function enforceEndDateReq() {
        if (!selStatus || !endDate) return;
        const val = selStatus.value;
        if (val === '2') {
            endDate.setAttribute('required','required');
        } else {
            endDate.removeAttribute('required');
        }
    }
    selStatus?.addEventListener('change', enforceEndDateReq);
    // initial
    enforceEndDateReq();
</script>
@endsection
